/*:
 * @plugindesc 立ち絵強調プラグイン v1.0
 * @author ミカ
 *
 * @help
 * このプラグインは、ピクチャ（立ち絵）の明るさ・透明度・拡大率を変えて
 * 強調表示・非強調表示を切り替えます。
 * 
 * ■プラグインコマンド
 * HighlightStand [ピクチャID] [true/false]
 * 例）
 * HighlightStand 1 true  // ピクチャID1を強調表示にする
 * HighlightStand 2 false // ピクチャID2を非強調表示にする
 * 
 * ■使い方
 * 立ち絵はあらかじめ「ピクチャの表示」で画面に出しておき、
 * イベントの「プラグインコマンド」から上記コマンドを入力して操作してください。
 * 
 * ■備考
 * ピクチャIDは「ピクチャの表示」の番号と対応しています。
 */

(function() {
  // 立ち絵強調用の関数
  function highlightPicture(id, highlight = true) {
    const sprite = SceneManager._scene._spriteset._pictureContainer.children[id - 1];
    if (sprite) {
      sprite.tint = highlight ? 0xFFFFFF : 0x808080;
      sprite.opacity = highlight ? 255 : 160;
      sprite.scale.x = sprite.scale.y = highlight ? 1.0 : 0.95;
    }
  }

  // プラグインコマンド追加
  const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    if (command === 'HighlightStand') {
      const id = Number(args[0]);
      const on = args[1] === 'true';
      highlightPicture(id, on);
    }
  };
})();
